
library(ggplot2)
library(patchwork)
library(dplyr)
library(lubridate)
library(data.table)

rm(list=ls())

Average.15mins <- function(dat){
  dat$Time <- as.POSIXct(dat$Time, format= "%H:%M:%OS")
  dat <- dat[order(dat$Time),]
  
  dat$Time <- round_date(dat$Time, "15 mins")
  dat <- dat %>% group_by(Time)
  dat <- dat %>% summarise("15 mins" = mean(net_pop))
  
  names(dat)[names(dat)=="15 mins"] <- "Count"
  
  return <- dat
}

Average.15mins_CO2 <- function(dat){
  
  dat$Time <- as.POSIXct(dat$Time, format= "%H:%M:%OS")
  dat <- dat[order(dat$Time),]
  
  dat$Time <- round_date(dat$Time, "15 mins")
  dat <- dat %>% group_by(Time)
  dat <- dat %>% summarise("15 mins" = mean(CO2))
  
  names(dat)[names(dat)=="15 mins"] <- "CO2"
  
  return <- dat
}

Plot_bar <- function(dat){

  P <- ggplot(dat, aes(x=Time, y=Count, fill= Type)) +
    geom_bar(stat = "identity") +
    scale_fill_manual(values=c("Shop" = "darkorange3", "Shebeen" = "green4", "Church" = "blue4", "Daycare" = "cyan3", "Salon" = "goldenrod2", "Clinic" = "#bb2900")) +
    theme_classic() + 
    theme(axis.text.x = element_text(size = 8, angle = 90, vjust = 0.5, hjust=1), 
          axis.title.x=element_blank()) +
    theme(axis.text.y = element_text(size=8)) + 
    ylab("Average People Count") +
    theme(legend.position = "none") 
  
  print(P)
}

Plot_line <- function(dat){
  
  P <- ggplot(data=Data.frame, aes(x=Time, y=CO2, group=1, colour= Type)) +
    geom_line() +
    geom_point() +
    scale_y_continuous(limits = c(400, NA)) +
    scale_colour_manual(values=c("Shop" = "darkorange3", "Shebeen" = "green4", "Church" = "blue4", "Daycare" = "cyan3", "Salon" = "goldenrod2", "Clinic" = "#bb2900")) +
    theme_classic() + theme(legend.position = "none") +
    ylab("Average CO2") +
    theme(axis.text=element_text(size=8)) +
    theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1))
  
  print(P)
}

Format <- function(dat){
  
  dat <- cbind(Count, CO2)
  dat <- dat  [,-c(3)]
  dat$Time <- as.POSIXct(dat$Time,format= "%H:%M:%OS")
  dat$Time <- strftime(dat$Time,"%H:%M")
  
  return <- dat
}

Average_mixing <- function(dat){

  dat$other_pop <- (dat$net_pop-1)*(dat$net_pop)
  net <- sum(dat$net_pop)
  other <- sum(dat$other_pop)
  dat <- (other/net)
  
  return <- dat
}

############ Averages by 15 mins ############
##### Shop C1 #####

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopC1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopC1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop C1') +theme(plot.title = element_text(size = 10))

##### Shop D1 #####

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopD1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopD1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop D1') +theme(plot.title = element_text(size = 10))

##### Shop A1 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopA1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopA1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop A1') +theme(plot.title = element_text(size = 10))

##### Shop B1 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopB1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopB1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop B1') +theme(plot.title = element_text(size = 10))

##### Shop F1 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopF1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopF1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop F1') +theme(plot.title = element_text(size = 10))


##### Shop E2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopE2.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopE2.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop E2') +theme(plot.title = element_text(size = 10))

##### Shop E1 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopE1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopE1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop E1') +theme(plot.title = element_text(size = 10))


##### Shop D2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopD2.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopD2.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop D2') +theme(plot.title = element_text(size = 10))

##### Shop C2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopC2.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopC2.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop C2') +theme(plot.title = element_text(size = 10))


##### Shop B2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopB2.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopB2.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop B2') +theme(plot.title = element_text(size = 10))

##### Shop A3 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopA3.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopA3.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop A3') +theme(plot.title = element_text(size = 10))

##### Shop A2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopA2.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShopA2.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shop"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shop A2') +theme(plot.title = element_text(size = 10))

##### Clinic A4 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA4.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA4.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Clinic"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Clinic A4') +theme(plot.title = element_text(size = 10))

##### Clinic A3 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA3.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA3.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Clinic"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Clinic A3') +theme(plot.title = element_text(size = 10))

##### Clinic A2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA2.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA2.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Clinic"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Clinic A2') +theme(plot.title = element_text(size = 10))

##### Clinic A1 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ClinicA1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Clinic"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Clinic A1') +theme(plot.title = element_text(size = 10))

##### Salon A3 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonA3.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonA3.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Salon"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Salon A3') +theme(plot.title = element_text(size = 10))

##### Salon A2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonA2.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonA2.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Salon"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Salon A2') +theme(plot.title = element_text(size = 10))

##### Salon A1 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonA1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonA1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Salon"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Salon A1') +theme(plot.title = element_text(size = 10))

##### Salon B3 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonB3.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonB3.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Salon"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Salon B3') +theme(plot.title = element_text(size = 10))

##### Salon B2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonB2.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonB2.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Salon"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Salon B2') +theme(plot.title = element_text(size = 10))

##### Salon B1 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonB1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/SalonB1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Salon"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Salon B1') +theme(plot.title = element_text(size = 10))

##### Church D2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchD2.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchD2.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Church"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Church D2') +theme(plot.title = element_text(size = 10))

##### Church B #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchB.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchB.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Church"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Church B') +theme(plot.title = element_text(size = 10))

##### Church E #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchE.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchE.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Church"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Church E') +theme(plot.title = element_text(size = 10))
##### Church D1 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchD1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchD1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Church"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'ChurchD1') +theme(plot.title = element_text(size = 10))

##### Church C #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchC.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchC.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Church"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Church C') +theme(plot.title = element_text(size = 10))

##### Church A #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchA.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ChurchA.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Church"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Church A') +theme(plot.title = element_text(size = 10))

##### Shebeen B5 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB5.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB5.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shebeen"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shebeen B5') +theme(plot.title = element_text(size = 10))

##### Shebeen B4 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB4.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB4.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shebeen"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shebeen B4') +theme(plot.title = element_text(size = 10))

##### Shebeen B3 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB3.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB3.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shebeen"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shebeen B3') +theme(plot.title = element_text(size = 10))

##### Shebeen B2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB2.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB2.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shebeen"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shebeen B2') +theme(plot.title = element_text(size = 10))

##### Shebeen B1 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenB1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shebeen"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shebeen B1') +theme(plot.title = element_text(size = 10))

##### Shebeen A4 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA4.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA4.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shebeen"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shebeen A4') +theme(plot.title = element_text(size = 10))

##### Shebeen A3 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA3.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA3.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shebeen"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shebeen A3') +theme(plot.title = element_text(size = 10))

##### Shebeen A2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA2.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA2.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shebeen"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shebeen A2') +theme(plot.title = element_text(size = 10))

##### Shebeen A2 #####
Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA1.csv")
Count <- Average.15mins(Data.frame)

Data.frame <- read.csv("./Matched CO2 and People Count_Anonymised/ShebeenA1.csv")
CO2 <- Average.15mins_CO2(Data.frame)

Data.frame <- Format(Data.frame)

Data.frame$Type <- "Shebeen"
B <- Plot_bar(Data.frame)
L <- Plot_line(Data.frame)
B/L + plot_annotation(title = 'Shebeen A1') +theme(plot.title = element_text(size = 10))
###################

############ Average other people ############
Buildings <- list.files("./Matched CO2 and People Count_Anonymised/", pattern=".csv$", full.names=TRUE)
Buildings.1 <- lapply(Buildings, read.csv)

Other_pop <- sapply(Buildings.1, Average_mixing)
Other_pop <- as.data.frame(Other_pop)

all_filenames <- Buildings %>%
  basename() %>%
  as.list()

all_filenames <- do.call(rbind, all_filenames)
Names <- as.data.frame(all_filenames)
Data.frame <- cbind(Names, Other_pop)

names(Data.frame)[names(Data.frame)=="V1"] <- "Building"
Data.frame$Building <- sub(".csv", "", Data.frame$Building)
write.csv (Data.frame, "./Average count/Average_otherpop_by building.csv")

###################

